#ifndef GST_CU_WRITER_OPTIONS_HPP__
#define GST_CU_WRITER_OPTIONS_HPP__

#include "buildspec.h"

#include <string>

#include <boost/optional.hpp>

namespace GST
{
namespace ClientUtils
{
enum class CoordinateSystemUpAxis
{
	Z,
	Y,
};

enum class CoordinateSystemHandedness
{
	Right,
	Left,
};

struct GST_API_EXPORT SegyWriterOptions
{
	bool writeOriginalTextHeader = false;
};

struct GST_API_EXPORT ObjWriterOptions
{
	bool writeNormals = true;
	CoordinateSystemUpAxis upAxis = CoordinateSystemUpAxis::Z;
	CoordinateSystemHandedness handedness = CoordinateSystemHandedness::Right;
};

struct GST_API_EXPORT KmlWriterOptions
{
	// proj4 parameters for global SRS
	std::string alternativeGlobalSrs;
	// proj4 for geoid correction
	//
	// either none or both should be set!
	std::string geoidSourceSrs;
	std::string geoidTargetSrs;
	// parameters of the ellipsoid
	//
	// negative = not set
	double earthEquatorialRadius = -1;
	double earthPolarRadius = -1;
};

struct GST_API_EXPORT Tiles3dWriterOptions
{
	uint64_t tilingThreshold = 20000;
	uint8_t maxLod = 4;
	bool writeNormals = true;
};

struct GST_API_EXPORT GltfWriterOptions
{
	bool writeNormals = true;
};

struct GST_API_EXPORT GocadWriterOptions
{
	bool writeAttributeValues = false;
	bool oneFilePerPart = false;
};

class GST_API_EXPORT WriterOptions
{
public:
	WriterOptions();
	WriterOptions(SegyWriterOptions options);
	WriterOptions(ObjWriterOptions options);
	WriterOptions(KmlWriterOptions options);
	WriterOptions(Tiles3dWriterOptions options);
	WriterOptions(GocadWriterOptions options);
	WriterOptions(GltfWriterOptions options);
	const boost::optional<SegyWriterOptions> &segyWriterOptions() const;
	const boost::optional<ObjWriterOptions> &objWriterOptions() const;
	const boost::optional<KmlWriterOptions> &kmlWriterOptions() const;
	const boost::optional<Tiles3dWriterOptions> &tiles3dWriterOptions() const;
	const boost::optional<GocadWriterOptions> &gocadWriterOptions() const;
	const boost::optional<GltfWriterOptions> &gltfWriterOptions() const;

private:
	boost::optional<SegyWriterOptions> m_segyWriterOptions;
	boost::optional<ObjWriterOptions> m_objWriterOptions;
	boost::optional<KmlWriterOptions> m_kmlWriterOptions;
	boost::optional<Tiles3dWriterOptions> m_tiles3dWriterOptions;
	boost::optional<GocadWriterOptions> m_gocadWriterOptions;
	boost::optional<GltfWriterOptions> m_gltfWriterOptions;
};

} // namespace ClientUtils
} // namespace GST
#endif // GST_CU_WRITER_OPTIONS_HPP__
